<?php
/*
Plugin Name: Donate Custom Content
Plugin URI: http://www.ewebcraft.com
Description: This plugin is mandatory for Donate Child Theme, This plugin is managing custom content(Events, Causes, Staff, Counters, Sponsors, Gallery).
Version: 1.0
Author: eWebCraft
Author URI: http://www.ewebcraft.com
*/

// Prevent direct script access
if ( !defined('ABSPATH') )
    die ( 'No direct access allowed' );

require_once( plugin_dir_path( __FILE__ ) . 'includes/cmb2/init.php' );

add_filter( 'cmb2_localized_data', 'ewc_cmb_set_date_format' );
function ewc_cmb_set_date_format( $l10n ) {
    $l10n['defaults']['date_picker']['dateFormat'] = 'yy-mm-dd';
    return $l10n;
}

class ewc_DonateCustomContent{
	
	function __construct() {
		add_action( 'init', array( $this, 'ewc_reg_events' ) );	
		add_action( 'init', array( $this, 'ewc_reg_counters' ) );
		add_action( 'init', array( $this, 'ewc_reg_staff' ) );
		add_action( 'init', array( $this, 'ewc_reg_sponsors' ) );
		add_action( 'init', array( $this, 'ewc_reg_causes' ) );
		add_action( 'init', array( $this, 'ewc_reg_causes_cats' ) );
		add_action( 'init', array( $this, 'ewc_reg_gallery' ) );
		add_action( 'init', array( $this, 'ewc_reg_gallery_cats' ) );
		add_filter( 'cmb2_meta_boxes', array( $this, 'ewc_donate_customfields' ) );
	}
	
	/*
	**	Registering events belongs to donate child theme for LayersWP
	*/
	function ewc_reg_events(){
		
		$labels = array(
			'name'               => __( 'Events', 'ewebcraft' ),
			'singular_name'      => __( 'Event', 'ewebcraft' ),
			'add_new'            => __( 'Add New', 'ewebcraft' ),
			'add_new_item'       => __( 'Add New Event', 'ewebcraft' ),
			'edit_item'          => __( 'Edit Event', 'ewebcraft' ),
			'new_item'           => __( 'New Event', 'ewebcraft' ),
			'all_items'          => __( 'All Events', 'ewebcraft' ),
			'view_item'          => __( 'View Event', 'ewebcraft' ),
			'search_items'       => __( 'Search Events', 'ewebcraft' ),
			'not_found'          => __( 'No Event Found', 'ewebcraft' ),
			'not_found_in_trash' => __( 'No Event Found in the Trash', 'ewebcraft' ), 
			'menu_name'          => __( 'Events', 'ewebcraft' )
		);
		
		$args = array(
			'labels'        => $labels,
			'description'   => __( 'Donate Events', 'ewebcraft' ),
			'public'        => true,
			'supports'      => array( 'title', 'thumbnail', 'editor' ),
			'has_archive'   => true,
			'rewrite' => array('slug' => 'event', 'with_front' => true),
			'query_var' => true
		);
		
		register_post_type( 'event', $args );
		flush_rewrite_rules( false );
				
	}
	
	
	/*
	**	Registering counters belongs to donate child theme for LayersWP
	*/
	function ewc_reg_counters(){
		
		$labels = array(
			'name'               => __( 'Counters', 'ewebcraft' ),
			'singular_name'      => __( 'Counter', 'ewebcraft' ),
			'add_new'            => __( 'Add New', 'ewebcraft' ),
			'add_new_item'       => __( 'Add New Counter', 'ewebcraft' ),
			'edit_item'          => __( 'Edit Counter', 'ewebcraft' ),
			'new_item'           => __( 'New Counter', 'ewebcraft' ),
			'all_items'          => __( 'All Counters', 'ewebcraft' ),
			'view_item'          => __( 'View Counter', 'ewebcraft' ),
			'search_items'       => __( 'Search Counters', 'ewebcraft' ),
			'not_found'          => __( 'No Counter Found', 'ewebcraft' ),
			'not_found_in_trash' => __( 'No Counter Found in the Trash', 'ewebcraft' ), 
			'menu_name'          => __( 'Counters', 'ewebcraft' )
		);
		
		$args = array(
			'labels'        => $labels,
			'description'   => __( 'Counters', 'ewebcraft' ),
			'supports'      => array( 'title' ),
			'has_archive'   => true,
			'public'        => true,
			'rewrite' => array('slug' => 'counter', 'with_front' => true),
			'query_var' => true
		);
		
		register_post_type( 'counter', $args );
		flush_rewrite_rules( false );
				
	}
	
	
	/*
	**	Registering staff belongs to donate child theme for LayersWP
	*/
	function ewc_reg_staff(){
		
		$labels = array(
			'name'               => __( 'Staff', 'ewebcraft' ),
			'singular_name'      => __( 'Staff', 'ewebcraft' ),
			'add_new'            => __( 'Add New', 'ewebcraft' ),
			'add_new_item'       => __( 'Add New Staff', 'ewebcraft' ),
			'edit_item'          => __( 'Edit Staff', 'ewebcraft' ),
			'new_item'           => __( 'New Staff', 'ewebcraft' ),
			'all_items'          => __( 'All Staff', 'ewebcraft' ),
			'view_item'          => __( 'View Staff', 'ewebcraft' ),
			'search_items'       => __( 'Search Staff', 'ewebcraft' ),
			'not_found'          => __( 'No Staff Found', 'ewebcraft' ),
			'not_found_in_trash' => __( 'No Staff Found in the Trash', 'ewebcraft' ), 
			'menu_name'          => __( 'Staff' )
		);
		
		$args = array(
			'labels'        => $labels,
			'description'   => __( 'Donate Staff', 'ewebcraft' ),
			'public'        => true,
			'supports'      => array( 'title', 'thumbnail', 'editor' ),
			'has_archive'   => true,
			'rewrite' => array('slug' => 'staff', 'with_front' => true),
			'query_var' => true
		);
		
		register_post_type( 'staff', $args );
		flush_rewrite_rules( false );
				
	}
	
	/*
	**	Registering sponsors belongs to donate child theme for LayersWP
	*/
	function ewc_reg_sponsors(){
		
		$labels = array(
			'name'               => __( 'Sponsors', 'ewebcraft' ),
			'singular_name'      => __( 'Sponsor', 'ewebcraft' ),
			'add_new'            => __( 'Add New', 'ewebcraft' ),
			'add_new_item'       => __( 'Add New Sponsor', 'ewebcraft' ),
			'edit_item'          => __( 'Edit Sponsor', 'ewebcraft' ),
			'new_item'           => __( 'New Sponsor', 'ewebcraft' ),
			'all_items'          => __( 'All Sponsors', 'ewebcraft' ),
			'view_item'          => __( 'View Sponsor', 'ewebcraft' ),
			'search_items'       => __( 'Search Sponsors', 'ewebcraft' ),
			'not_found'          => __( 'No Sponsor Found', 'ewebcraft' ),
			'not_found_in_trash' => __( 'No Sponsor Found in the Trash', 'ewebcraft' ), 
			'menu_name'          => __( 'Sponsors', 'ewebcraft' )
		);
		
		$args = array(
			'labels'        => $labels,
			'description'   => __( 'Donate Sponsors', 'ewebcraft' ),
			'public'        => true,
			'supports'      => array( 'title', 'thumbnail', 'ewebcraft' ),
			'has_archive'   => true,
			'rewrite' => array('slug' => 'sponsor', 'with_front' => true),
			'query_var' => true
		);
		
		register_post_type( 'sponsor', $args );
		flush_rewrite_rules( false );
				
	}
	
	
	/*
	**	Registering causes belongs to donate child theme for LayersWP
	*/
	function ewc_reg_causes(){
		
		$labels = array(
			'name'               => __( 'Causes', 'ewebcraft' ),
			'singular_name'      => __( 'Cause', 'ewebcraft' ),
			'add_new'            => __( 'Add New', 'ewebcraft' ),
			'add_new_item'       => __( 'Add New Cause', 'ewebcraft' ),
			'edit_item'          => __( 'Edit Cause', 'ewebcraft' ),
			'new_item'           => __( 'New Cause', 'ewebcraft' ),
			'all_items'          => __( 'All Causes', 'ewebcraft' ),
			'view_item'          => __( 'View Cause', 'ewebcraft' ),
			'search_items'       => __( 'Search Causes', 'ewebcraft' ),
			'not_found'          => __( 'No Cause Found', 'ewebcraft' ),
			'not_found_in_trash' => __( 'No Cause Found in the Trash', 'ewebcraft' ), 
			'menu_name'          => __( 'Causes', 'ewebcraft' )
		);
		
		$args = array(
			'labels'        => $labels,
			'description'   => __( 'Donate Causes', 'ewebcraft' ),
			'public'        => true,
			'supports'      => array( 'title', 'thumbnail', 'editor' ),
			'has_archive'   => true,
			'rewrite' => array('slug' => 'cause', 'with_front' => true),
			'query_var' => true
		);
		
		register_post_type( 'cause', $args );
		flush_rewrite_rules( false );
				
	}
	
	
	/*
	**	Registering categories/taxonomies causes belongs to donate child theme for LayersWP
	*/
	function ewc_reg_causes_cats(){
		
		$labels = array(
			'name'              => __( 'Causes Categories', 'ewebcraft' ),
			'singular_name'     => __( 'Causes Category', 'ewebcraft' ),
			'search_items'      => __( 'Search Causes Categories', 'ewebcraft' ),
			'all_items'         => __( 'All Causes Categories', 'ewebcraft' ),
			'parent_item'       => __( 'Parent Category', 'ewebcraft' ),
			'edit_item'         => __( 'Edit Cause Category', 'ewebcraft' ), 
			'update_item'       => __( 'Update Cause Category', 'ewebcraft' ),
			'add_new_item'      => __( 'Add New Cause Category', 'ewebcraft' ),
			'new_item_name'     => __( 'New Cause Category', 'ewebcraft' ),
			'menu_name'         => __( 'Categories', 'ewebcraft' )
		);
		
		$args = array(
			'labels' => $labels,
			'hierarchical' => true,
			'public'        => true,
			'query_var' => true,
			'rewrite' => array('slug' => 'cause', 'with_front' => true)
		);
		
		register_taxonomy( 'cause_category', 'cause', $args );
		flush_rewrite_rules( false );
		
	}
	
	
	/*
	**	Registering gallery belongs to donate child theme for LayersWP
	*/
	function ewc_reg_gallery(){
		
		$labels = array(
			'name'               => __( 'Gallery', 'ewebcraft' ),
			'singular_name'      => __( 'Gallery', 'ewebcraft' ),
			'add_new'            => __( 'Add New', 'ewebcraft' ),
			'add_new_item'       => __( 'Add New Gallery', 'ewebcraft' ),
			'edit_item'          => __( 'Edit Gallery', 'ewebcraft' ),
			'new_item'           => __( 'New Gallery', 'ewebcraft' ),
			'all_items'          => __( 'All Galleries', 'ewebcraft' ),
			'view_item'          => __( 'View Gallery', 'ewebcraft' ),
			'search_items'       => __( 'Search Galleries', 'ewebcraft' ),
			'not_found'          => __( 'No Gallery Found', 'ewebcraft' ),
			'not_found_in_trash' => __( 'No Gallery Found in the Trash', 'ewebcraft' ), 
			'menu_name'          => __( 'Galleries', 'ewebcraft' )
		);
		
		$args = array(
			'labels'        => $labels,
			'description'   => __( 'Donate Galleries', 'ewebcraft' ),
			'public'        => true,
			'supports'      => array( 'title', 'thumbnail' ),
			'has_archive'   => true,
			'rewrite' => array('slug' => 'gallery', 'with_front' => true),
			'query_var' => true
		);
		
		register_post_type( 'gallery', $args );
		flush_rewrite_rules( false );
				
	}
	
	
	/*
	**	Registering categories/taxonomies gallery belongs to donate child theme for LayersWP
	*/
	function ewc_reg_gallery_cats(){
		
		$labels = array(
			'name'              => __( 'Galleries Categories', 'ewebcraft' ),
			'singular_name'     => __( 'Galleries Category', 'ewebcraft' ),
			'search_items'      => __( 'Search Galleries Categories', 'ewebcraft' ),
			'all_items'         => __( 'All Gallery Categories', 'ewebcraft' ),
			'parent_item'       => __( 'Parent Category', 'ewebcraft' ),
			'edit_item'         => __( 'Edit Gallery Category', 'ewebcraft' ), 
			'update_item'       => __( 'Update Gallery Category', 'ewebcraft' ),
			'add_new_item'      => __( 'Add New Gallery Category', 'ewebcraft' ),
			'new_item_name'     => __( 'New Gallery Category', 'ewebcraft' ),
			'menu_name'         => __( 'Categories', 'ewebcraft' )
		);
		
		$args = array(
			'labels' => $labels,
			'hierarchical' => true,
			'public'        => true,
			'query_var' => true,
			'rewrite' => array('slug' => 'gallery_category', 'with_front' => true)
		);
		
		register_taxonomy( 'gallery_category', 'gallery', $args );
		flush_rewrite_rules( false );
		
	}
	
	
	/*
	**	Setting up custom fields for custom post types belongs to donate child theme for LayersWP
	*/
	function ewc_donate_customfields( array $meta_boxes ){
		$icons = file_get_contents(plugin_dir_url( __FILE__ ).'includes/font-awesome-data-serialized.php');
		$icons = unserialize($icons);
		foreach( $icons as $icon => $icon_code ){
			$iconsArr[$icon] = $icon;
		}
		//	Events custom fields	
		$meta_boxes['ewc_donate_events'] = array(
			'id'            => 'ewc_donate_events',
			'title'         => __( 'Event Information' ),
			'object_types'  => array( 'event' ), // Post type
			'context'       => 'normal',
			'priority'      => 'high',
			'fields'        => array(
									array(
										'name'       => __( 'Event Date', 'ewebcraft' ),
										'id'         => 'event_date',
										'type'       => 'text_date'
									),
									array(
										'name'       => __( 'Event Start Time', 'ewebcraft' ),
										'id'         => 'event_start_time',
										'type'       => 'text_time'
									),
									array(
										'name'       => __( 'Event End Time', 'ewebcraft' ),
										'id'         => 'event_end_time',
										'type'       => 'text_time'
									),
									array(
										'name'       => __( 'Event Location', 'ewebcraft' ),
										'id'         => 'event_location',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Map Location Latitude', 'ewebcraft' ),
										'id'         => 'map_latitude',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Map Location Longitude', 'ewebcraft' ),
										'id'         => 'map_longitude',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Add Icon', 'ewebcraft' ),
										'id'         => 'event_icon',
										'type'       => 'select',
										'options' => $iconsArr
									)
								)
			
		);
		
		
		//	Causes custom fields
		$meta_boxes['ewc_donate_causes'] = array(
			'id'            => 'ewc_donate_causes',
			'title'         => __( 'Cause Information' ),
			'object_types'  => array( 'cause' ), // Post type
			'context'       => 'normal',
			'priority'      => 'high',
			'fields'        => array(
									array(
										'name'       => __( 'Raised', 'ewebcraft' ),
										'id'         => 'raised',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Goal', 'ewebcraft' ),
										'id'         => 'goal',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Sponsors', 'ewebcraft' ),
										'id'         => 'sponsors',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Donate Button URL', 'ewebcraft' ),
										'id'         => 'donate_button_url',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Progress Bar Value', 'ewebcraft' ),
										'id'         => 'progress_bar_value',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Add Icon', 'ewebcraft' ),
										'id'         => 'cause_icon',
										'type'       => 'file'
									)
								)
			
		);
		
		//	Staff custom fields
		$meta_boxes['ewc_donate_staff'] = array(
			'id'            => 'ewc_donate_staff',
			'title'         => __( 'Staff Information' ),
			'object_types'  => array( 'staff' ), // Post type
			'context'       => 'normal',
			'priority'      => 'high',
			'fields'        => array(
									array(
										'name'       => __( 'Designation', 'ewebcraft' ),
										'id'         => 'staff_designation',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Facebook', 'ewebcraft' ),
										'id'         => 'staff_facebook',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Twitter', 'ewebcraft' ),
										'id'         => 'staff_twitter',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'LinkedIn', 'ewebcraft' ),
										'id'         => 'staff_linkedin',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'YouTube', 'ewebcraft' ),
										'id'         => 'staff_youtube',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'GooglePlus', 'ewebcraft' ),
										'id'         => 'staff_google',
										'type'       => 'text'
									)
								)
			
		);
		
		//	Counters custom fields
		$meta_boxes['ewc_donate_counter'] = array(
			'id'            => 'ewc_donate_counter',
			'title'         => __( 'Counter Information' ),
			'object_types'  => array( 'counter' ), // Post type
			'context'       => 'normal',
			'priority'      => 'high',
			'fields'        => array(
									array(
										'name'       => __( 'Counter Value', 'ewebcraft' ),
										'id'         => 'counter_value',
										'type'       => 'text'
									),
									array(
										'name'       => __( 'Add Icon', 'ewebcraft' ),
										'id'         => 'counter_icon',
										'type'       => 'select',
										'options' => $iconsArr
									)
								)
			
		);
		
		return $meta_boxes;
		
	}
		
}


$ewc_DonateCustomContent = new ewc_DonateCustomContent();
global $ewc_DonateCustomContent;