<?php
include_once ( get_stylesheet_directory() . '/partials/tgm-init.php' );
add_action( 'widgets_init', 'ewc_pages_sidebar' );
function ewc_pages_sidebar() {
    register_sidebar( array(
		'id'		=> 'page-sidebar',
		'name'		=> __( 'Page Sidebar', 'ewebcraft' ),
		'description'	=> __( 'This sidebar will only appear on pages only.', 'ewebcraft' ),
		'before_widget'	=> '<aside id="%1$s" class="content widget %2$s">',
		'after_widget'	=> '</aside><!--Closed-->',
		'before_title'	=> '<h5 class="section-nav-title">',
		'after_title'	=> '</h5>',
	) );
}

/**
* Customizer Defaults
*
* The following filter is used to setup the customizer defaults which are setup by your child theme
*
*/
function layers_agency_customizer_defaults( $defaults ){

    $defaults = array(
        'body-fonts' => 'Roboto',
        'heading-fonts' => 'Droid Serif',
        'form-fonts' => 'Roboto',
        'header-background-color' => '#333333',
        'header-sticky' => '1',
        'footer-sidebar-count' => '0',
        'header-overlay' => '1',
        'footer-background-color' => '#333333',
        'footer-link-color' => '#ffffff',
    );

    return $defaults;
}
add_filter( 'layers_customizer_control_defaults', 'layers_agency_customizer_defaults' );

add_action( 'wp_enqueue_scripts', 'ewc_theme_style' );
function ewc_theme_style() {
	wp_enqueue_style( 'donate-style2', get_stylesheet_directory_uri() . '/assets/css/bootstrap.min.css' );
	wp_enqueue_style( 'donate-style3', get_stylesheet_directory_uri() . '/assets/css/font-awesome.min.css' );
	wp_enqueue_style( 'donate-style4', get_stylesheet_directory_uri() . '/assets/css/style.css' );
	wp_enqueue_style( 'donate-style5', get_stylesheet_directory_uri() . '/assets/css/animate-custom.css' );
	wp_enqueue_style( 'donate-style6', get_stylesheet_directory_uri() . '/assets/css/loader.css' );
	wp_enqueue_style( 'donate-style7', get_stylesheet_directory_uri() . '/assets/css/prettyPhoto.css' );
	wp_enqueue_style( 'donate-style8', get_stylesheet_directory_uri() . '/assets/css/jquery.bxslider.css' );
	
	
	wp_enqueue_script('jquery');
	wp_enqueue_script('donate-js1', get_stylesheet_directory_uri() . '/assets/js/bootstrap.min.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js2', get_stylesheet_directory_uri() . '/assets/js/waypoints.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js3', get_stylesheet_directory_uri() . '/assets/js/smoothScroll.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js4', get_stylesheet_directory_uri() . '/assets/js/jquery.flexisel.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js5', get_stylesheet_directory_uri() . '/assets/js/hoverintent.min.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js6', get_stylesheet_directory_uri() . '/assets/js/filterable.pack.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js10', get_stylesheet_directory_uri() . '/assets/js/jquery.prettyPhoto.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js11', get_stylesheet_directory_uri() . '/assets/js/jquery.mixitup.min.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js7', get_stylesheet_directory_uri() . '/assets/js/custom.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js8', get_stylesheet_directory_uri() . '/assets/js/common.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js20', get_stylesheet_directory_uri() . '/assets/js/maps.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js20', get_stylesheet_directory_uri() . '/assets/js/maps.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js21', get_stylesheet_directory_uri() . '/assets/js/jquery.bxslider.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js22', get_stylesheet_directory_uri() . '/assets/js/modernizr.js', array('jquery'), '', true  );
	wp_enqueue_script('donate-js99', get_stylesheet_directory_uri() . '/assets/theme.js', array('jquery'), '', true  );
}


function ewc_preloader() {
    echo '<div id="loader-wrapper"><div id="loader"></div><div class="loader-section section-left"></div>		<div class="loader-section section-right"></div><div class="load_title"></div></div>';
}
add_action('wp_footer', 'ewc_preloader', 100);

add_image_size( 'banner-image', 750, 268, true );

add_filter( 'the_title', 'do_shortcode' );
add_filter('widget_text', 'do_shortcode');
add_filter('the_content', 'do_shortcode');
add_filter('widget_execphp', 'do_shortcode');
add_filter('widget_title', 'do_shortcode');
add_filter( 'wp_terms', 'do_shortcode' );

include_once ( get_stylesheet_directory() . '/partials/widget-causes.php' );
include_once ( get_stylesheet_directory() . '/partials/widget-twitter.php' );
include_once ( get_stylesheet_directory() . '/partials/contact_widget.php' );



function ewc_excerpt($num) {
    $limit = $num+1;
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt);
    return  $excerpt;
}

function ewc_display_causes(){
	$args = array(
		'type'                     => 'cause',
		'child_of'                 => 0,
		'parent'                   => '',
		'orderby'                  => 'name',
		'order'                    => 'ASC',
		'hide_empty'               => 1,
		'hierarchical'             => 1,
		'exclude'                  => '',
		'include'                  => '',
		'number'                   => '',
		'taxonomy'                 => 'cause_category',
		'pad_counts'               => false 
	); 	
	$categories = get_categories($args); 
	if( $categories ){
		$causes_res = '<div class="causes-nav"><div class="row"><div class="col-md-12 col-sm-12 col-xs-12 text-center"><div class="wrapper"><ul id="portfolio-filter">';
		$causes_res .= '<li class="current"><a href="#all" title="">All</a></li>';
		foreach ($categories as $category) {
			$cat_class = '';
			$causes_res .= '<li class=""><a href="#'.$category->slug.'" title="">'.$category->name.'</a></li>';	
			
		}	
		$causes_res .= '</ul>
                  </div>
              </div>
             </div>';
			 
	
	$args = array(
				'post_type' => 'cause',
				'posts_per_page' => -1,
				'post_status' => 'publish'
			);
			 
	$the_query = new WP_Query( $args );	
	if ( $the_query->have_posts() ) {
		$causes_res .= '<div class="row"><div class="col-md-12 col-sm-12 col-xs-12"> <ul id="portfolio-list">';	
		while ( $the_query->have_posts() ) {
			$the_query->the_post();
			$terms = get_the_terms( get_the_ID(), 'cause_category' );
			foreach( $terms as $term ){
				$cat_slug = $term->slug;	
			}
			
			$goal = $raised = $donation = '';
			$raised = get_post_meta( get_the_ID(), 'raised', true );
			$goal = get_post_meta( get_the_ID(), 'goal', true );
			if( $raised || $goal ){
				$donation = '<strong>Donation :</strong> '.$raised;	
				if( $goal ){
					$donation .= ' / '.$goal;	
				}
			}
			$causes_res .= '<li style="display: block;" class="'.$cat_slug.' jw-animate-gen noOpacity" data-gen="fadeIn" data-gen-offset="90%">
							  <div class="description">
									<span class="description-pics"> 
									'.get_the_post_thumbnail(get_the_ID(),'medium', array('class'=>'img-responsive update-parent')).'
									</span>
									   <div class="detail text-center">
											<h2>'.get_the_title().'</h2>
											<p>'.$donation.'</p>
											<p>
											'.ewc_excerpt(20).'
											</p>
											<a href="'.get_permalink().'">Cause Detail</a>
										 </div>
								</div>
							</li>';
		}
		$causes_res .= '</ul></div></div>';
		
	}	//	if ( $the_query->have_posts() ) {		 
	wp_reset_postdata();		 
			 
			 
	}
	return $causes_res;
}


add_filter( 'the_content', 'ewc_cause_information' ); 
 
function ewc_cause_information( $content ) { 
	global $post;
    if ( is_singular('cause')) {
        $custom_information = '';
		$progress_bar = '';
		$progress_bar_value = get_post_meta( get_the_ID(), 'progress_bar_value', true );
		$raised = get_post_meta( get_the_ID(), 'raised', true );
		$goal = get_post_meta( get_the_ID(), 'goal', true );
		$donate_button_url = get_post_meta( get_the_ID(), 'donate_button_url', true );
		$sponsors = get_post_meta( get_the_ID(), 'sponsors', true );
		
		if( $donate_button_url ){
			$donate_button = '<a href="'.$donate_button_url.'">DONATE</a>';	
		}
		
		if( $sponsors ){
			$sponsors_info = '<span>
                                <i class="fa fa-heart"></i>
                                '.$sponsors.'
                               </span>';	
		}
		
		if( $goal || $raised ){
			$goal_info = '<p class="text-right"><strong>
                                Goal :</strong> '.$raised.' / '.$goal.'</p>';	
		}
		
		if( $raised ){
			$raised_info = '<p><strong>Raised :</strong> '.$raised.' </p>';	
		}
		
		if( $progress_bar_value ){
			$find = array('%', 'px');
			$replace = array('', '');
			$progress_bar_value_refine = str_replace( $find, $replace, $progress_bar_value );
			$progress_bar = '<div id="progressBar" class="progressBar" data-animate-offset="'.$progress_bar_value_refine.'"><div>';	
		}
		
		$content = $custom_information = '<div class="grey-box">
                            '.$progress_bar.'</div></div> 
                            <div class="row">
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                '.$raised_info.'
                                </div>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                '.$goal_info.'
                                </div>
                                
                                <div class="col-md-6 col-sm-6 col-xs-5">
                                '.$sponsors_info.'
                                </div>
                                <div class="col-md-6 col-sm-6 col-xs-7 text-right">
                                 '.$donate_button.'
                                </div>
                                
                            </div> <!--ROW FOR TEXT-->
                            
                        </div>'.$content;
	}

    return $content;
}

add_filter('body_class','ewc_cause_body_classes');

function ewc_eventInformationContent( $content ){
	global $post;
	$map = $information = '';
    if ( is_singular('event')){

		$event_date = get_post_meta( get_the_ID(), 'event_date', true );
		$event_start_time = get_post_meta( get_the_ID(), 'event_start_time', true );
		$event_end_time = get_post_meta( get_the_ID(), 'event_end_time', true );
		$event_location = get_post_meta( get_the_ID(), 'event_location', true );
		$map_latitude = get_post_meta( get_the_ID(), 'map_latitude', true );
		$map_longitude = get_post_meta( get_the_ID(), 'map_longitude', true );

		$date_time_info = '';
		if( $event_date || $event_start_time || $event_end_time ){
			$date_time_info = '<p><i class="fa fa-calendar"></i> ';
			
			if( $event_date ){
				$date_time_info .= date( 'D m, Y', strtotime( $event_date ) );
			}
			
			if( $event_start_time ){
				$date_time_info .= ' at '.$event_start_time;
			}
			
			if( $event_end_time ){
				$date_time_info .= ' - '.$event_end_time;
			}
			
			$date_time_info .= '</p>';
		}
		
		if( $event_location ){
			$event_location_refine = '<p class="text-right"><i class="fa fa-map-marker"></i>
                                '.$event_location.'</p>';	
		}
					
		$information = '<div class="row singelevent-info"> 
                                <div class="col-md-6 col-sm-6 col-xs-6">
                                '.$date_time_info.'
                                </div>
                                <div class="col-md-6 col-sm-6 col-xs-6">
                                '.$event_location_refine.'
                                </div>
                                
                            </div>';
		if( $map_latitude && $map_longitude ){
			$map = '<div class="events">
                    <h2 class="jw-animate-gen noOpacity" data-gen="fadeInDown" data-gen-offset="75%">
                    Locate the Location</h2>
                        <div class="maps jw-animate-gen noOpacity" data-gen="fadeInLeft" data-gen-offset="75%">
                        <div id="googleMap"></div>
                        </div> <!--MAP-->
                    </div>
					<script type="text/javascript">
					var mapLat = "'.$map_latitude.'";
					var mapLong = "'.$map_longitude.'";
					</script>';	
		}
	}
	
	return $information.$content.$map;
	
}
add_filter( 'the_content', 'ewc_eventInformationContent' );

function ewc_next_prevNav( $content ){
	global $post;
	$pagination = '';
	if ( is_singular('event') || is_singular('post') || is_singular('cause') ){
		$prev_next_label = 'Post';	
		if( is_singular('event') ){
			$prev_next_label = 'Event';	
		}
		if( is_singular('cause') ){
			$prev_next_label = 'Cause';	
		}
		$prev = get_permalink(get_adjacent_post(false,'',false));
		$next = get_permalink(get_adjacent_post(false,'',true));
		ob_start();
		?>
		<div class="event-btn">
            <div data-gen-offset="80%" data-gen="fadeInLeft" class="jw-animate-gen noOpacity animated fadeInLeft">
                <a class="pull-left" href="<?php echo $prev; ?>">
                    <i class="fa fa-long-arrow-left"></i>Previous <?php echo $prev_next_label;?>
                </a>
            </div>
            <div data-gen-offset="80%" data-gen="fadeInRight" class="jw-animate-gen noOpacity animated fadeInRight">       
                <a class="pull-right" href="<?php echo $next; ?>">
                Next <?php echo $prev_next_label;?><i class="fa fa-long-arrow-right"></i></a>
           </div>
        </div>	
        <?php
		$pagination = ob_get_contents();
		ob_end_clean();
	}
	return $content . $pagination;
}
add_filter( 'the_content', 'ewc_next_prevNav' );

function ewc_cause_body_classes($classes)
{
 global $post;
 // Use switch to filter through custom post types
 switch(get_post_type())
 {
 case 'cause':
// If custom post type is portfolio, add portfolio class to body.
 $classes[] = 'causes-detail';
 break;

 }
 // return the $classes array
 return $classes;
}

function layers_donate_include_widgets(){
    require_once( get_stylesheet_directory() . '/partials/causes.php' );
	require_once( get_stylesheet_directory() . '/partials/events.php' );
	require_once( get_stylesheet_directory() . '/partials/staff.php' );
}
add_action( 'widgets_init' , 'layers_donate_include_widgets', 50 );



function ewc_twitter_time($a) {
    //get current timestampt
    $b = strtotime("now"); 
    //get timestamp when tweet created
    $c = strtotime($a);
    //get difference
    $d = $b - $c;
    //calculate different time values
    $minute = 60;
    $hour = $minute * 60;
    $day = $hour * 24;
    $week = $day * 7;
        
    if(is_numeric($d) && $d > 0) {
        //if less then 3 seconds
        if($d < 3) return "right now";
        //if less then minute
        if($d < $minute) return floor($d) . " seconds ago";
        //if less then 2 minutes
        if($d < $minute * 2) return "about 1 minute ago";
        //if less then hour
        if($d < $hour) return floor($d / $minute) . " minutes ago";
        //if less then 2 hours
        if($d < $hour * 2) return "about 1 hour ago";
        //if less then day
        if($d < $day) return floor($d / $hour) . " hours ago";
        //if more then day, but less then 2 days
        if($d > $day && $d < $day * 2) return "yesterday";
        //if less then year
        if($d < $day * 365) return floor($d / $day) . " days ago";
        //else return more than a year
        return "over a year ago";
    }
}
add_filter('upload_mimes', 'enable_extended_upload');

function enable_extended_upload ( $mime_types =array() ) {

// The MIME types listed here will be allowed in the media library.
// You can add as many MIME types as you want.
$mime_types['zip'] = 'application/zip';
$mime_types['json'] = 'application/json';

return $mime_types;
}