<?php
/**
 * Template Name: Events Page
 *
 * @package Layers
 * @since Layers 1.0.0
 */

get_header(); ?>

<section id="post-<?php the_ID(); ?>" <?php post_class( 'content-main clearfix' ); ?>>
	<?php do_action('layers_before_page_loop'); ?>
	<div class="row">
		<article class="column span-8">
		<?php if( have_posts() ) : ?>

			<?php while( have_posts() ) : the_post(); ?>
					<?php get_template_part( 'partials/content', 'single' ); ?>
			<?php endwhile; // while has_post(); ?>
			
		<?php endif; // if has_post() ?>
        
        <?php
        wp_reset_postdata();
		$args = array(
				'post_type' => 'event',
				'posts_per_page' => -1,
				'post_status' => 'publish'
			);
		$the_query = new WP_Query( $args );
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				
				$event_date = get_post_meta( get_the_ID(), 'event_date', true );
				if( $event_date ){
					$event_date_refine = $event_date.', ';	
				}
				$event_start_time = get_post_meta( get_the_ID(), 'event_start_time', true );
				if( $event_start_time ){
					$event_start_time_refine = ' at '.$event_start_time;	
				}
				$event_end_time = get_post_meta( get_the_ID(), 'event_end_time', true );
				if( $event_end_time ){
					$event_end_time_refine = ' - '.$event_end_time;	
				}
				$event_location = get_post_meta( get_the_ID(), 'event_location', true );
				
			?>
			<div class="causes-nav">
            	<div data-gen-offset="70%" data-gen="fadeInLeft" class="events events-<?php the_ID(); ?> jw-animate-gen noOpacity animated fadeInLeft">
                    <span class="description-pics">
                        <?php	the_post_thumbnail('banner-image', array('class'=>'img-responsive'));	?>
                    </span>
                    <div class="event-box">
                      <a href="<?php	the_permalink();	?>"><?php	the_title();	?></a>
                        <div class="row custominformation"> 
                            <div class="col-md-6 col-sm-6 col-xs-6">
                            <p><i class="fa fa-calendar"></i><?php echo $event_date_refine.$event_start_time_refine.$event_end_time_refine; ?></p>
                            </div>
                            <div class="col-md-6 col-sm-6 col-xs-6">
                            <p class="text-right"><i class="fa fa-map-marker"></i>
                            <?php	echo $event_location;	?></p>
                            </div>
                            
                        </div> <!--ROW FOR TEXT-->
                        
                    </div>
                </div>
            </div><!--causes-nav-->
			<?php	
			}
		}
		 wp_reset_postdata();
		?>
        
        
        
        </article>
        <div class="column pull-right sidebar no-gutter span-4">
			<?php dynamic_sidebar( 'page-sidebar' ); ?>
        </div>
	</div>
    <?php do_action('layers_after_page_loop'); ?>
</section>

<?php get_footer(); ?>