<?php
/**
 * Template Name: Gallery Page
 *
 * @package Layers
 * @since Layers 1.0.0
 */

get_header(); ?>

<section id="post-<?php the_ID(); ?>" <?php post_class( 'content-main clearfix' ); ?>>
	<?php do_action('layers_before_page_loop'); ?>
	<div class="row">
		<article class="column span-12">
		<?php if( have_posts() ) : ?>

			<?php while( have_posts() ) : the_post(); ?>
					<?php get_template_part( 'partials/content', 'single' ); ?>
			<?php endwhile; // while has_post(); ?>
			
		<?php endif; // if has_post() ?>
        
        <?php
        wp_reset_postdata();
		$args = array(
		'type'                     => 'gallery',
		'child_of'                 => 0,
		'parent'                   => '',
		'orderby'                  => 'name',
		'order'                    => 'ASC',
		'hide_empty'               => 1,
		'hierarchical'             => 1,
		'exclude'                  => '',
		'include'                  => '',
		'number'                   => '',
		'taxonomy'                 => 'gallery_category',
		'pad_counts'               => false 
	); 	
	$categories = get_categories($args); 
	if( $categories ){
		$causes_res = '<div class="causes-nav"><div class="row"><div class="col-md-12 col-sm-12 col-xs-12 text-center"><div class="wrapper"><ul id="filter-list">';
		$causes_res .= '<li class="filter active" data-filter="all"><a href="#" title="">All</a></li>';
		foreach ($categories as $category) {
			$cat_class = '';
			$causes_res .= '<li class="filter" data-filter="'.$category->slug.'"><a href="#" title="">'.$category->name.'</a></li>';	
			
		}	
		$causes_res .= '</ul>
                  </div>
              </div>
             </div>';
			 
	
	$args = array(
				'post_type' => 'gallery',
				'posts_per_page' => -1,
				'post_status' => 'publish'
			);
			 
	$the_query = new WP_Query( $args );	
	if ( $the_query->have_posts() ) {
		$causes_res .= '<div class="row gallerypage"><div class="col-md-12 col-sm-12 col-xs-12"> <ul id="portfolio">';	
		while ( $the_query->have_posts() ) {
			$the_query->the_post();
			$terms = get_the_terms( get_the_ID(), 'gallery_category' );
			foreach( $terms as $term ){
				$cat_slug = $term->slug;
				$cat_name = $term->name;	
			}
			
			$image_attributes = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID(), 'full' ) );
			
			$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );
			$thumb_url = $thumb['0'];
			
			
			$causes_res .= '<li class="item '.$cat_slug.'">
								 <div class="effects">
									  <div class="img">
									  <a href="'.$thumb_url.'"  rel="prettyPhoto[gallery]">
									  <img src="'.$thumb_url.'" alt="gallery"> 
										 <div class="overlay">
									   <i class="fa fa-search"></i>
									   <p>'.$cat_name.'</p> </div> 
										 </a>
									  </div> 
								 </div>    
							  </li>';
		}
		$causes_res .= '</ul></div></div>';
		echo $causes_res;
	}	//	if ( $the_query->have_posts() ) {		 
	wp_reset_postdata();
	}
	?>
        
        
        
        </article>
        
	</div>
    <?php do_action('layers_after_page_loop'); ?>
</section>

<?php get_footer(); ?>