<?php
class ewc_events_widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		'ewc_events_widget', 
		
		__('Donate Events', 'ewebcraft'), 
		
			array( 'description' => __( 'Display events', 'ewebcraft' ), ) 
		);
	}

	public function widget( $args, $instance ) {
		$afterWidget = $args['after_widget'];
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo $args['before_widget'];
		if ( ! empty( $title ) )
		echo $args['before_title'] . $title . $args['after_title'];
		
		$events_per_page = '3';
		if( $instance['events_per_page'] > 0 ){
				$events_per_page = $instance['events_per_page'];
		}
		
		$event_type_opt = '>';
		if( $instance['eventtype'] == 'past' ){
			$event_type_opt = '<';	
		}

		$today = date('Y-m-d');
		$args = array(
			'post_type' => 'event',
			'post_status' => 'publish',
			'meta_key' => 'event_date',
			'posts_per_page' => $events_per_page,
			'meta_query' => array(
									array(
										'key' => 'event_date',
										'value' => $today,
										'compare' => $event_type_opt.'=',
										'type' => 'date'
									)
			),
			'orderby' => 'meta_value_num',
			'order' => 'ASC'
		);
		
		$the_query = new WP_Query( $args );	
		if ( $the_query->have_posts() ) {
			echo '<div class="side-events">';
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$event_date = get_post_meta( get_the_ID(), 'event_date', true );
				if( $event_date ){
					$event_date_refine = $event_date.', ';	
				}
				$event_start_time = get_post_meta( get_the_ID(), 'event_start_time', true );
				if( $event_start_time ){
					$event_start_time_refine = ' at '.$event_start_time;	
				}
				$event_end_time = get_post_meta( get_the_ID(), 'event_end_time', true );
				if( $event_end_time ){
					$event_end_time_refine = ' - '.$event_end_time;	
				}
				$event_location = get_post_meta( get_the_ID(), 'event_location', true );
				?>
				<div data-gen-offset="60%" data-gen="fadeInRight" class="latest-causes jw-animate-gen noOpacity animated fadeInRight">
                    <div class="row">
                        <div class="col-md-3 col-sm-3 col-xs-3">
                      	<?php	the_post_thumbnail('thumbnail', array('class'=>'img-responsive'));	?>
                        </div>
                        <div class="col-md-9 col-sm-9 col-xs-9">
                        <a href="<?php	the_permalink();	?>"><?php	the_title();	?></a>
                        <p><i class="fa fa-calendar"></i><?php echo $event_date_refine.$event_start_time_refine.$event_end_time_refine; ?></p>
                        </div>
                    </div> 
                </div>
				<?php	
			}
			echo '</div>';
		}	//	if ( $the_query->have_posts() ) {
		echo $afterWidget;
		wp_reset_postdata();
	}
		
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
		$title = $instance[ 'title' ];
		}
		else {
		$title = __( 'Title', 'ewebcraft' );
		}
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
        <p>
        	<label for="<?php echo $this->get_field_id( 'eventtype' ); ?>"><?php _e( 'Select type for events:' , 'ewebcraft' ); ?></label> 
        	<select id="<?php echo $this->get_field_id( 'eventtype' ); ?>" name="<?php echo $this->get_field_name( 'eventtype' ); ?>">
            	<option value="past"<?php if(esc_attr($instance['eventtype'])=='past'){ ?> selected="selected"<?php } ?>><?php _e('Past Events' , 'ewebcraft'); ?></option>
                <option value="new"<?php if(esc_attr($instance['eventtype'])=='new'){ ?> selected="selected"<?php } ?>><?php _e('Up-Coming Events' , 'ewebcraft'); ?></option>
            </select>
            
            
        </p>
        <p>
		<label for="<?php echo $this->get_field_id( 'events_per_page' ); ?>"><?php _e( 'Number of Events to show:' , 'ewebcraft' ); ?></label> 
		<input class="" id="<?php echo $this->get_field_id( 'events_per_page' ); ?>" name="<?php echo $this->get_field_name( 'events_per_page' ); ?>" type="text" value="<?php echo esc_attr( $instance['events_per_page'] ); ?>" style="width:80px;" />
		</p>
		<?php 
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['eventtype'] = ( ! empty( $new_instance['eventtype'] ) ) ? strip_tags( $new_instance['eventtype'] ) : '';
		$instance['events_per_page'] = ( ! empty( $new_instance['events_per_page'] ) ) ? strip_tags( $new_instance['events_per_page'] ) : '';
		return $instance;
	}
} // Class ewc_events_widget ends here


function ewc_load_events_widget() {
	register_widget( 'ewc_events_widget' );
}
add_action( 'widgets_init', 'ewc_load_events_widget' );



/*
**	Showing Causes
*/


class ewc_causes_widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		'ewc_causes_widget', 
		
		__('Donate Causes', 'ewebcraft'), 
		
			array( 'description' => __( 'Display donate causes', 'ewebcraft' ), ) 
		);
	}

	public function widget( $args, $instance ) {
		$afterWidget = $args['after_widget'];
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo $args['before_widget'];
		if ( ! empty( $title ) )
		echo $args['before_title'] . $title . $args['after_title'];
		
		$events_per_page = '3';
		if( $instance['events_per_page'] > 0 ){
				$events_per_page = $instance['events_per_page'];
		}
		
		
		
		$args = array(
			'post_type' => 'cause',
			'post_status' => 'publish',
			'posts_per_page' => $events_per_page
		);
		
		$the_query = new WP_Query( $args );	
		if ( $the_query->have_posts() ) {
			echo '<div class="side-causes">';
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				
				?>
				<div data-gen-offset="60%" data-gen="fadeInRight" class="latest-causes jw-animate-gen noOpacity animated fadeInRight">
                    <div class="row">
                        <div class="col-md-3 col-sm-3 col-xs-3">
                       	<?php	the_post_thumbnail('thumbnail', array('class'=>'img-responsive'));	?>
                        </div>
                        <div class="col-md-9 col-sm-9 col-xs-9">
                        <a href="<?php	the_permalink();	?>"><?php	the_title();	?></a>
                        <p><?php echo ewc_excerpt(10); ?></p>
                        </div>
                    </div>
                    
                    
                    
                </div>
				<?php	
			}
			echo '</div>';
		}	//	if ( $the_query->have_posts() ) {
		echo $afterWidget;
		wp_reset_postdata();
	}
		
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
		$title = $instance[ 'title' ];
		}
		else {
		$title = __( 'Title', 'ewebcraft' );
		}
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
        
        <p>
		<label for="<?php echo $this->get_field_id( 'events_per_page' ); ?>"><?php _e( 'Number of Causes to show:' , 'ewebcraft' ); ?></label> 
		<input class="" id="<?php echo $this->get_field_id( 'events_per_page' ); ?>" name="<?php echo $this->get_field_name( 'events_per_page' ); ?>" type="text" value="<?php echo esc_attr( $instance['events_per_page'] ); ?>" style="width:80px;" />
		</p>
		<?php 
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['events_per_page'] = ( ! empty( $new_instance['events_per_page'] ) ) ? strip_tags( $new_instance['events_per_page'] ) : '';
		return $instance;
	}
} // Class ewc_causes_widget ends here


function ewc_load_causes_widget() {
	register_widget( 'ewc_causes_widget' );
}
add_action( 'widgets_init', 'ewc_load_causes_widget' );




/*
**	Showing Gallery
*/


class ewc_gallery_widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		'ewc_gallery_widget', 
		
		__('Donate Gallery', 'ewebcraft'), 
		
			array( 'description' => __( 'Display donate gallery', 'ewebcraft' ), ) 
		);
	}

	public function widget( $args, $instance ) {
		$afterWidget = $args['after_widget'];
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo $args['before_widget'];
		if ( ! empty( $title ) )
		echo $args['before_title'] . $title . $args['after_title'];
		
		$events_per_page = '6';
		if( $instance['events_per_page'] > 0 ){
				$events_per_page = $instance['events_per_page'];
		}
		$galleries = array();
		foreach( explode( ',', $instance[ 'donate_gal' ] ) as $galSlug ){
			$galleries[] = "'".trim( $galSlug )."'";	
		}

		$args = array(
			'post_type' => 'gallery',
			'post_status' => 'publish',
			'posts_per_page' => $events_per_page,
			'tax_query' => array(
				array(
					'taxonomy' => 'gallery_category',
					'field'    => 'slug',
					'terms'    => $galleries,
				),
			),
		);
		
		$the_query = new WP_Query( $args );	
		if ( $the_query->have_posts() ) {
			echo '<div class="side-gallery">';
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				
				?>
				<?php	the_post_thumbnail('thumbnail', array('class'=>'latest pictures'));	?>
				<?php	
			}
			echo '</div>';
		}	//	if ( $the_query->have_posts() ) {
		echo $afterWidget;
		wp_reset_postdata();
	}
		
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
		$title = $instance[ 'title' ];
		}
		else {
		$title = __( 'Title', 'ewebcraft' );
		}
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
        <p>
		<label for="<?php echo $this->get_field_id( 'events_per_page' ); ?>"><?php _e( 'Number of Images to show:' , 'ewebcraft' ); ?></label> 
		<input class="" id="<?php echo $this->get_field_id( 'events_per_page' ); ?>" name="<?php echo $this->get_field_name( 'events_per_page' ); ?>" type="text" value="<?php echo esc_attr( $instance['events_per_page'] ); ?>" style="width:80px;" />
		</p>
        <?php
		$args = array(
			'type'                     => 'gallery',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'name',
			'order'                    => 'ASC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'gallery_category',
			'pad_counts'               => false 
		); 	
		$categories = get_categories($args); 
		if( $categories ){
			?>
            <p>
            <label>Categories slugs with comma</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'donate_gal' ); ?>" name="<?php echo $this->get_field_name( 'donate_gal' ); ?>" type="text" value="<?php echo esc_attr( $instance['donate_gal'] ); ?>" />
            </p>
			<?php
			
		}
		
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['events_per_page'] = ( ! empty( $new_instance['events_per_page'] ) ) ? strip_tags( $new_instance['events_per_page'] ) : '';
		$instance['donate_gal'] = ( ! empty( $new_instance['donate_gal'] ) ) ? strip_tags( $new_instance['donate_gal'] ) : '';
		return $instance;
	}
} // Class ewc_gallery_widget ends here


function ewc_load_gallery_widget() {
	register_widget( 'ewc_gallery_widget' );
}
add_action( 'widgets_init', 'ewc_load_gallery_widget' );


/*
**	Showing Sponsors
*/


class ewc_sponsors_widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		'ewc_sponsors_widget', 
		
		__('Donate Sponsors', 'ewebcraft'), 
		
			array( 'description' => __( 'Display sponsors carousel', 'ewebcraft' ), ) 
		);
	}

	public function widget( $args, $instance ) {
		$afterWidget = $args['after_widget'];
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo $args['before_widget'];
		if ( ! empty( $title ) )
		echo $args['before_title'] . $title . $args['after_title'];
		
		
		

		$args = array(
			'post_type' => 'sponsor',
			'post_status' => 'publish',
			'posts_per_page' => '-1'
		);
		
		$the_query = new WP_Query( $args );	
		if ( $the_query->have_posts() ) {
			echo '<div class="sponsorsWrap col-md-12 col-sm-12 col-xs-12 jw-animate-gen noOpacity" data-gen="fadeIn" data-gen-offset="90%"><ul id="'.$instance['bxid'].'">';
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				
				?>
				<li><?php	the_post_thumbnail('thumbnail');	?></li>
				<?php	
			}
			echo '</ul></div>';
			?>
			<script type="text/javascript">
			jQuery(function() {
            	jQuery("#<?php echo esc_js( $instance['bxid'] ); ?>").flexisel({
					visibleItems: <?php if( $instance['visible_slides'] ){ echo esc_js($instance['visible_slides']);} else{ echo '5';} ?>,
					animationSpeed: 1000,
					autoPlay: true,
					autoPlaySpeed: 3000,            
					pauseOnHover: true,
					enableResponsiveBreakpoints: true,
					responsiveBreakpoints: { 
						portrait: { 
							changePoint:480,
							visibleItems: 1
						}, 
						landscape: { 
							changePoint:640,
							visibleItems: 2
						},
						tablet: { 
							changePoint:768,
							visibleItems: 3
						}
					}
				});
			})
            </script>
			<?php
		}	//	if ( $the_query->have_posts() ) {
		echo $afterWidget;
		wp_reset_postdata();
	}
		
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
		$title = $instance[ 'title' ];
		}
		else {
		$title = __( 'Title', 'ewebcraft' );
		}
		if( !$instance['bxid'] ){	$instance['bxid'] = 'bxSlider-'.rand(0, 999);	}
		?>
        <input id="<?php echo $this->get_field_id( 'bxid' ); ?>" name="<?php echo $this->get_field_name( 'bxid' ); ?>" type="hidden" value="<?php echo esc_attr( $instance['bxid'] ); ?>" />
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
        <p>
		<label for="<?php echo $this->get_field_id( 'visible_slides' ); ?>"><?php _e( 'Visible Slides: '  , 'ewebcraft'); ?></label> 
		<input class="" id="<?php echo $this->get_field_id( 'visible_slides' ); ?>" name="<?php echo $this->get_field_name( 'visible_slides' ); ?>" type="text" value="<?php echo esc_attr( $instance['visible_slides'] ); ?>" style="width:80px;" />
		</p>
        
        
		<?php
		
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['bxid'] = ( ! empty( $new_instance['bxid'] ) ) ? strip_tags( $new_instance['bxid'] ) : '';
		$instance['visible_slides'] = ( ! empty( $new_instance['visible_slides'] ) ) ? strip_tags( $new_instance['visible_slides'] ) : '';
		
		return $instance;
	}
} // Class ewc_sponsors_widget ends here


function ewc_load_sponsor_widget() {
	register_widget( 'ewc_sponsors_widget' );
}
add_action( 'widgets_init', 'ewc_load_sponsor_widget' );



/*

Counters

*/


class ewc_counters_widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		'ewc_counters_widget', 
		
		__('Donate Counters', 'ewebcraft'), 
		
			array( 'description' => __( 'Display counters', 'ewebcraft' ), ) 
		);
	}

	public function widget( $args, $instance ) {
		$afterWidget = $args['after_widget'];
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo $args['before_widget'];
		if ( ! empty( $title ) )
		echo $args['before_title'] . $title . $args['after_title'];
		
		$counters_per_page = '4';
		if( $instance['counters_per_page'] > 0 ){
				$counters_per_page = $instance['counters_per_page'];
		}
		
		$args = array(
			'post_type' => 'counter',
			'post_status' => 'publish',
			'posts_per_page' => $counters_per_page,
		);
		
		$the_query = new WP_Query( $args );	
		if ( $the_query->have_posts() ) {
			echo '<div class="row donateCountersRow">
    <div class="details clearfix">';
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				
				$counter_icon = get_post_meta( get_the_ID(), 'counter_icon', true );
				$counter_value = get_post_meta( get_the_ID(), 'counter_value', true );
				
				?>
				<div class="col-md-3 col-sm-6 col-xs-12 text-center jw-animate-gen noOpacity" data-gen-offset="90%" data-gen="fadeInUp">
              <div class="diamond">
              	<?php	if( $counter_icon ){	?>
              	<i class="fa <?php echo $counter_icon; ?>"></i>
                <?php	}	?>
               
              </div>
              <div class="diamond-inner">
                    <span class="stat-count highlight"><?php echo esc_attr( $counter_value ); ?></span>
                    <div class="milestone-details"><?php the_title(); ?></div>
                </div>
              
            </div>
				<?php	
			}
			echo '</div></div>';
		}	//	if ( $the_query->have_posts() ) {
		echo $afterWidget;
		wp_reset_postdata();
	}
		
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
		$title = $instance[ 'title' ];
		}
		else {
		$title = __( 'Title', 'ewebcraft' );
		}
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
        
        <p>
		<label for="<?php echo $this->get_field_id( 'counters_per_page' ); ?>"><?php _e( 'Number of Counters to show:' , 'ewebcraft'); ?></label> 
		<input class="" id="<?php echo $this->get_field_id( 'counters_per_page' ); ?>" name="<?php echo $this->get_field_name( 'counters_per_page' ); ?>" type="text" value="<?php echo esc_attr( $instance['counters_per_page'] ); ?>" style="width:80px;" />
		</p>
		<?php 
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['counters_per_page'] = ( ! empty( $new_instance['counters_per_page'] ) ) ? strip_tags( $new_instance['counters_per_page'] ) : '';
		return $instance;
	}
} // Class ewc_events_widget ends here


function ewc_load_coutners_widget() {
	register_widget( 'ewc_counters_widget' );
}
add_action( 'widgets_init', 'ewc_load_coutners_widget' );