<?php
class ewc_twitter_widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		'ewc_twitter_widget', 
		
		__('Donate Twitter', 'ewebcraft'), 
		
			array( 'description' => __( 'Display Tweets', 'ewebcraft' ), ) 
		);
	}

	public function widget( $args, $instance ) {
		$afterWidget = $args['after_widget'];
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo $args['before_widget'];
		if ( ! empty( $title ) )
		echo $args['before_title'] . $title . $args['after_title'];
		
		$tweets_per_page = '3';
		if( $instance['tweets_per_page'] > 0 ){
				$tweets_per_page = $instance['tweets_per_page'];
		}
		
		$consumer_key = $instance['consumerKey']; 
		$consumer_secret = $instance['consumerSecret'];
		$oauth_access_token = $instance['accessToken']; 
		$oauth_access_token_secret = $instance['accessTokenSecret'];
		$twitterID = $instance['twitterID'];
		
		$feedUrl=get_stylesheet_directory_uri().'/partials/twitter.php?url=timeline&screen_name='.$twitterID.'&count='.$tweets_per_page.'&include_entities=true&include_rts=false&exclude_replies=true&consumerKey='.$consumer_key.'&consumerSecret='.$consumer_secret.'&consumerToken='.$oauth_access_token.'&oauth_access_token_secret='.$oauth_access_token_secret;
		
		$twitterFeeds=file_get_contents($feedUrl);
		$feedArray=json_decode($twitterFeeds,true);
		?>
		<div class="jw-animate-gen noOpacity" data-gen="fadeInUp" data-gen-offset="85%">
            <!--for twitter feed columns-->
           <div class="twitter">
           		
                <?php
                	if(array_key_exists('errors',$feedArray))
					{
						foreach($feedArray['errors'] as $key=>$error)
						{
				?>
                			<p><?php echo esc_attr( $error['message'] );?> (error code: <?php echo esc_attr( $error['code'] ); ?>)</p>
                <?php			
						}	
					}else
					{
						foreach($feedArray as $index => $data)
						{
				?>
                			<p>
                                <a href="https://www.twitter.com/<?php echo esc_url($data['user']['screen_name']);?>" target="_blank">@<?php echo $data['user']['screen_name']?></a> <?php echo $data['text']?> <br>
                                 <strong class="datetime"><?php echo ewc_twitter_time($data['created_at'])?></strong>
                            </p>
                <?php			
						}	
					}
				?>
                
               
            </div>   
       	</div>	
        <?php
		echo $afterWidget;
		wp_reset_postdata();
	}
		
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
		$title = $instance[ 'title' ];
		}
		else {
		$title = __( 'Recent Tweets', 'ewebcraft' );
		}
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
        
         <p>
		<label for="<?php echo $this->get_field_id( 'tweets_per_page' ); ?>"><?php _e( 'Number of Tweets to show:' , 'ewebcraft' ); ?></label> 
		<input class="" id="<?php echo $this->get_field_id( 'tweets_per_page' ); ?>" name="<?php echo $this->get_field_name( 'tweets_per_page' ); ?>" type="text" value="<?php echo esc_attr( $instance['tweets_per_page'] ); ?>" style="width:80px;" />
		</p>
        
        <p><a target="_blank" href="http://www.theme2html.com/social-plugin.html#twitter-api">How to Find Twitter ID and API Key?</a></p>
        
        <p>
        	<label for="<?php echo $this->get_field_id( 'twitterID' ); ?>"><?php _e( 'Twitter ID:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'twitterID' ); ?>" name="<?php echo $this->get_field_name( 'twitterID' ); ?>" type="text" value="<?php echo esc_attr( $instance[ 'twitterID' ] ); ?>" />
            
            
        </p>
        
        <p>
        	<label for="<?php echo $this->get_field_id( 'consumerKey' ); ?>"><?php _e( 'Consumer Key:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'consumerKey' ); ?>" name="<?php echo $this->get_field_name( 'consumerKey' ); ?>" type="text" value="<?php echo esc_attr( $instance[ 'consumerKey' ] ); ?>" />
            
            
        </p>
        
        <p>
        	<label for="<?php echo $this->get_field_id( 'consumerSecret' ); ?>"><?php _e( 'Consumer Secret:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'consumerSecret' ); ?>" name="<?php echo $this->get_field_name( 'consumerSecret' ); ?>" type="text" value="<?php echo esc_attr( $instance[ 'consumerSecret' ] ); ?>" />
            
            
        </p>
        
        <p>
        	<label for="<?php echo $this->get_field_id( 'accessToken' ); ?>"><?php _e( 'Access Token:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'accessToken' ); ?>" name="<?php echo $this->get_field_name( 'accessToken' ); ?>" type="text" value="<?php echo esc_attr( $instance[ 'accessToken' ] ); ?>" />
            
            
        </p>
        
        <p>
        	<label for="<?php echo $this->get_field_id( 'accessTokenSecret' ); ?>"><?php _e( 'Access Token Secret:' , 'ewebcraft' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'accessTokenSecret' ); ?>" name="<?php echo $this->get_field_name( 'accessTokenSecret' ); ?>" type="text" value="<?php echo esc_attr( $instance[ 'accessTokenSecret' ] ); ?>" />
            
            
        </p>
        
        
       
		<?php 
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['twitterID'] = ( ! empty( $new_instance['twitterID'] ) ) ? strip_tags( $new_instance['twitterID'] ) : '';
		$instance['consumerKey'] = ( ! empty( $new_instance['consumerKey'] ) ) ? strip_tags( $new_instance['consumerKey'] ) : '';
		$instance['consumerSecret'] = ( ! empty( $new_instance['consumerSecret'] ) ) ? strip_tags( $new_instance['consumerSecret'] ) : '';
		$instance['accessToken'] = ( ! empty( $new_instance['accessToken'] ) ) ? strip_tags( $new_instance['accessToken'] ) : '';
		$instance['accessTokenSecret'] = ( ! empty( $new_instance['accessTokenSecret'] ) ) ? strip_tags( $new_instance['accessTokenSecret'] ) : '';
		$instance['tweets_per_page'] = ( ! empty( $new_instance['tweets_per_page'] ) ) ? strip_tags( $new_instance['tweets_per_page'] ) : '';
		return $instance;
	}
} // Class ewc_twitter_widget ends here


function ewc_load_twitter_widget() {
	register_widget( 'ewc_twitter_widget' );
}
add_action( 'widgets_init', 'ewc_load_twitter_widget' );



/*
**	Showing Causes
*/


